#!/usr/local/bin/perl

sub dump_database {

	my (@arr, $sth_hold, $sql, $dumpfile, @values);
 	my($time_val) = time;
 	my($current_date) = &date_time;
	my $line = sprintf("#****** %-60s ******#\n","");
	   $line =~ s/ /*/g;

	$dumpfile = "$database\-$time_val.db";

	$dumpfile =~ s/\//'_'/eg;
	$dumpfile = "$dumppath/$dumpfile";
	open (DUMP_FILE,">>$dumpfile") or &print_error("Can't Open File $dumpfile!");
	print DUMP_FILE $line;
	printf DUMP_FILE ("#****** %-60s ******#\n","File Generated By miniSQL Keeper");
	printf DUMP_FILE ("#****** %-60s ******#\n","Copyright 1997, CGL Internet Services, Inc.");
	printf DUMP_FILE ("#****** %-60s ******#\n","on $current_date");
	printf DUMP_FILE ("#****** %-60s ******#\n","Database: $database");
	print DUMP_FILE $line;

	@arr = $dbh->ListTables;	
    
	foreach $i (0..$#arr)	{
		
		if ($excluded_tables =~ /,$arr[$i],/) {
		
		}else {
			
			#*** get create table sql for existing fields
			$sql  = &SQLCreate($arr[$i]);
			$sql = "CREATE TABLE $arr[$i] \($sql\)\n";
			print DUMP_FILE $line;
			printf DUMP_FILE ("#****** %-60s ******#\n","TABLE:$arr[$i]");
			print DUMP_FILE "DROP TABLE $arr[$i]\n";
			print DUMP_FILE $sql;

			$sth_hold = $dbh->Query(&SQLSelect($arr[$i])) or &sql_fail($sql);
			#***generate Insert stmts
			$sql = &sql_insert_stmt($arr[$i]);	
			while(@values = $sth_hold->FetchRow) {
				$ins_sql = "";
				foreach $i (0..$#values) {
					if ($field_type[$i] == 2) {
						$values[$i] =~ s/\'/$quote_rep/eg;
						$values[$i] = "\'$values[$i]\'";
					}
					$ins_sql .= $values[$i].", ";
				}
				$ins_sql = &remove_last_comma($ins_sql);
				print DUMP_FILE "$sql $ins_sql\)\n";
			}
			printf DUMP_FILE ("#****** %-60s ******#\n","END TABLE:$arr[$i]");

		}
	}

	close (DUMP_FILE);
	print &html("Database dump");
	
	$dumpfile =~ s/$root_path//;
	print "\n</b>Database dumped successfully to  <a href = \"$dumpfile\">$dumpfile</a>\n";
	print &html_bot;
	return 1;	
}

sub restore_db {
	
	my($fileinfo, $i, $sth, $err, $temp, $line, $dump_database, @arr, @files, @file_sort);
	if (!$in{'file'}) {

		print &html("Restore Database");
		print "<FONT SIZE=3><b><FONT COLOR = \"RED\"><blink>WARNING</blink></font>: This action will restore the database to its exact state as defined in the restore file.&nbsp&nbsp;\n";
		print "Any new tables created after the backup that created the restore file WILL BE LOST.</font></b><br><br>\n";
		print "Select File to restore database from:<ul>\n";
		print $form_method;
	
		opendir (DUMP_DIR, $dumppath) or &print_error("Unable to open Backup directory.");
		$i = -1;
		while ($filename = readdir(DUMP_DIR)) {
			$fileinfo  = "<FONT SIZE=2>";
			$dump_database = substr($filename, 0, index($filename, "-"));
			$fileinfo .= "Database <b>$dump_database</b>, dumped ";
			$temp = $filename;
			$temp =~ s/$dump_database-//;
			$temp =~ s/.db//;
			$fileinfo .= &date_time($temp);
			$fileinfo .= "</FONT>";

			if ($filename =~ /.db/) {
				$i++;
				$files[$i] = qq*<li><INPUT TYPE="radio" NAME="file" VALUE="$dumppath/$filename"> $filename ($fileinfo) <a href="$dumpurl/$filename">View File</a></li><BR>\n* 
			}
		}
		closedir(DUMP_DIR);
		@file_sort = reverse (sort (@files));
		for (0..$#file_sort) {print $file_sort[$_];}
		
		print "</ul>\n";
		print "<center><INPUT TYPE=\"HIDDEN\" NAME=\"action\" VALUE=\"restore_db\"></center>\n";
		print "<center><INPUT TYPE=\"SUBMIT\" NAME=\"Button\" VALUE=\"Restore Database\"></center>\n";
	
	} else {
		#first we drop ALL existing tables
		@arr = $dbh->ListTables;
		foreach $i (0..$#arr){
			&drop_table_final ($arr[$i]) unless $excluded_tables =~ /,$arr[$i],/;
		}
		#and then we do the file

        open (INFILE, $in{'file'}) or &print_error("Unable to open Backup File: $in{'file'}");
		while (<INFILE>) {
			$line++;
			chomp;
			if  (substr($_,0,1) ne "#") {
				#print "Command:$_<br>";
				if (/DROP TABLE/) {
					
					$temp = $_;
					$temp =~ s/DROP TABLE //;
					
					if (&table_exists($temp)) {
					
						#print "<br>Command Will be executed. Table $temp exists<br>";
						&drop_table_final($temp);
					
					} else {
					
						#print "<br>Command Will NOT be executed. Table $temp exists<br>";
						#print "<br>Table $temp DOES NOT exist<br>";

					}
				
				} else {
					$sth = $dbh->Query($_) or &print_error("SQL Statement Failed Line $line: $_\n");
				}
			}
		}
		close INFILE;
		print &html("Restore Database");
		print "Database restored successfully from file:";
		$in{'file'} =~ s/$root_path//eg;
		print "&nbsp;<b><i>$in{'file'}</b></i><br>";

	}
	
	print &html_bot;
	return 1;

}

sub to_ansi_sql {
	#IMPORTANT: THIS WORKS ONLY WITH mSQL ver 1

	my $line = sprintf("/****** %-60s ******/\n","");
	   $line =~ s/ /*/g;
	my $include_drops = 1;							
	my $dumpfile = "$dumppath/$database.sql"; 			#Output file
	my(@arr, $i, $j, $sth_select, $sql, $field_count);
	my $now = &date_time;

	open (DUMP_FILE,"+>$dumpfile") or print "Can't Open File $dumpfile. Reason: $! ";

	print  DUMP_FILE $line;
	printf DUMP_FILE ("/****** %-60s ******/\n","Script Generated By mSQL Keeper");
	printf DUMP_FILE ("/****** %-60s ******/\n","Copyright 1997 CGL Internet Services.");
	printf DUMP_FILE ("/****** %-60s ******/\n","Script Date: $now");
	printf DUMP_FILE ("/****** %-60s ******/\n","Database: $database");
	print  DUMP_FILE $line;

	if (not (@arr = $dbh->ListTables)) {
		&print_error("Could Not Read Tables from Database $database. Reason: ".($Msql::db_errstr));
		exit;
	}

	foreach $j (0..$#arr)	{
		
		next if $excluded_tables =~ /,$arr[$j],/;

		my $table = $arr[$j];
		my @values;
		my $fields = &ansi_field_list($table);

		print  DUMP_FILE $line;
		printf DUMP_FILE ("/****** %-60s ******/\n"," TABLE $table ");
		print DUMP_FILE &ansi_getDropStmt($table) if $include_drops;

		#*** get create table sql for fields
		$sql = "CREATE TABLE dbo.$table (\n\t".&ansiSQL_Create($table).")\nGO\n";
		print DUMP_FILE "PRINT \'CREATING TABLE $table\'\n\GO\n";
		print DUMP_FILE $sql;

		$sth_select = $dbh->Query("SELECT $fields FROM $table");
		#***generate Insert stmts
		print DUMP_FILE "PRINT \'INSERTING DATA INTO TABLE $table\'\n\GO\n";
		$sql = "INSERT INTO $table (\n\t $fields \n) VALUES (\n\t";
		$field_count = &table_field_count($table);

		while(@values = $sth_select->FetchRow) {
			my $ins_sql = "";
			foreach $i (0..$field_count - 1) {
				if (not defined($values[$i])) {
					#if not defined, then this is probably a NULL value
					if ($field_not_nulls[$i]) {
						#can NOT take nulls, even though is not defined
						#not likely to happen, but better be safe that sorry
						$values[$i] = "\'\'" if $isChar[$i];
						$values[$i] = "0" unless $isChar[$i];
					} else {
						#can take NULLS
						$values[$i] = "NULL";	
					}

				} else {
					$values[$i] = &ansi_sql_string($values[$i]) if $isChar[$i]; 
					#SQL encode strings if we are dealinmg with a char field


				}
				$ins_sql .= $values[$i];
				$ins_sql .= ",\n\t" if ($i < $field_count - 1);
			}
			print DUMP_FILE "$sql $ins_sql\)\n";
			print DUMP_FILE "GO\n";
		}
		print DUMP_FILE "PRINT \'FINISHED WITH TABLE $table\'\n\GO\n";
		printf DUMP_FILE ("/****** %-60s ******/\n"," END TABLE:$table ");
		print  DUMP_FILE $line;
	}

	close (DUMP_FILE);
	print &html;
	$dumpfile =~ s/$root_path//;
	print "\n</b>Database dumped successfully to  <a href = \"$dumpfile\">$dumpfile</a>\n";
	print &html_bot;
	return;
}

sub ansiSQL_Create {
	
	#returns a string with the field names, type, lenght in SQL format in a table
	#for example, FIELD_NANE1 CHAR(30) NOT NULL PRIMARY KEY, FIELD_NANE2 INT NOT NULL, etc...
	my ($table) = @_;
	my ($sql, $sth, $i);

	if (not ($sth = $dbh->ListFields($table))) {
		print "Cant get fields for table $table";
		exit;
	}
	
	undef @isChar;
	undef @field_not_nulls;

    for $i (0..$sth->numfields-1) {
		
		my $type = &sqltype($sth->type->[$i]);
		my $field_sql  = $sth->name->[$i];
		
		$isChar[$i] = 1 if $type eq "CHAR";
		$type = "TEXT" if $sth->length->[$i] > 255;
		
		$field_sql .= " $type ";
		$field_sql .= "(".$sth->length->[$i].")" if $type eq "CHAR";
		
		if ($sth->is_not_null->[$i]) {
			$field_sql .= " NOT NULL "; 
			$field_not_nulls[$i] = 1;
		} else {
			$field_sql .= " NULL ";
			$field_not_nulls[$i] = 0;
		}

		#$field_sql .= " PRIMARY KEY " if $sth->is_pri_key->[$i];
		$sql .= $field_sql;
		$sql .= ",\n\t" if $i < $sth->numfields-1;
	}
	return $sql;
}

sub ansi_getDropStmt {
	my ($table) = @_;
	my $drop;
	$drop  = "IF EXISTS (SELECT * from sysobjects WHERE id = object_id(\'dbo.$table\'))\n";
	$drop .= "BEGIN\n";
	$drop .= "\tPRINT \'DROPPING TABLE $table\'\n";
	$drop .= "\tDROP TABLE dbo\.$table\n";
	$drop .= "END\n";
	$drop .= "GO\n\n";
	return $drop;
}


sub ansi_field_list {
	
	#returns field names for a table in a comma separated string (useful for Selects and Inserts)
	my ($table) = @_;
	my $sth = $dbh->ListFields($table);
	my ($sql, $i);
	for $i (0..$sth->numfields - 1) {
		$sql .= $sth->name->[$i];
		$sql .= ",\n\t" if $i < $sth->numfields-1;
	}
	return $sql;
}

sub ansi_sql_string {
	#prepares an sql string for an SQL statement by enclosing it in ''
	#and escapes the ' character and the '' character inside a value
	my ($temp) = @_;
	$temp =~ s/\'/$quote_rep/eg;
	$temp = "\'$temp\'";
	return $temp;
}

1;